HMMlogLike <-
function(stateParameters,gamma,x,distribution,...){
  
  m=dim(gamma)[1]
  
  #state dep. as list
  startP = extern2intern(parameter=stateParameters,distribution=distribution,m=m)
  
  if(distribution=="poisson"){
    
    #density
    f0 = function(x,par){lambda=par;return(dpois(x,lambda=lambda))}

    return(HMMlogLikeIntern(stateParameters=startP,gamma,x,f0))
    
  }
  
  if(distribution=="normal"){
    
    #density
    f0 = function(x,par){
      mu    = par[1]
      sigma = par[2]
      return(dnorm(x,mean=mu,sd=sigma))
    }
    
    return(HMMlogLikeIntern(stateParameters=startP,gamma,x,f0))
    
  }
  
  if(distribution=="mv_normal"){
       
    #density
    f0 = function(x,par){
      mu    = par$mu
      sigma = par$sigma
      return(dmnorm(x=x,mean=mu,varcov=sigma))
    }
    

    return(HMMlogLikeIntern(stateParameters=startP,gamma,x,f0))
    
  }
  
}
