investigateMergedHMMs <-
function(x,hmm,independenceClusters){
  
  
  stateParameters = hmm@stateParameters
  gamma = hmm@transitionMatrix
  distribution = hmm@internVariables$distribution
  
  
  #set no. of states, and number of dep. clusters
  G0 = independenceClusters
  m=length(unlist(G0))
  r0 = length(G0)  
  
  if(r0==m) return("No merging is possible.")
  
  #calculate posiible number of merges
  nMerge = 0
  for(i in 1:r0) nMerge = length(G0[[i]]) - 1 + nMerge 
  
  #initialise path of models
  modelPath = list()
  modelPath[[nMerge+1]] = mergeHMM(hmm=hmm,G=as.list(1:m))
  
  #initialise path of partitions
  GPath = list()
  GPath[[nMerge+1]] = as.list(1:m)
  
  #initialise path of local decoding entropies
  localDecodingEntropies = numeric(nMerge+1)
  localDecodingEntropies[nMerge+1] = 
    localDecodingEntopie(x,hmm,G=as.list(1:m))$entropy
  
  
  #iteratively merge from top to bottom
  for(i in nMerge:1){
    
    #all possible partitions one level lower
    GlistTmp = getNextPartitions(G=GPath[[i+1]],independenceClusters=G0) 
    Btmp = length(GlistTmp)
    
    
    #set a function to use lapply with local decoding entropy
    localDecodingEntropyTmp = function(i,Glist){
      return(localDecodingEntopie(x,hmm,G=Glist[[i]])$entropy)
    }
    
    
    
    #find partition which provides highest drop of local dec. entr.
    parallelOutput = lapply(X=1:Btmp,localDecodingEntropyTmp,Glist=GlistTmp)
    j0 = which.min(unlist(parallelOutput))
    
    
    #set values of merged model
    GPath[[i]] = GlistTmp[[j0]]
    modelPath[[i]] = mergeHMM(hmm=hmm,G=GlistTmp[[j0]])
    localDecodingEntropies[i] = unlist(parallelOutput)[j0]
    
  }
  
  
  return(list(modelPath=rev(modelPath),
              GPath=rev(GPath),
              localDecodingEntropies=rev(localDecodingEntropies)))
  
}
