mergeTpm <-
function(gamma,G){
  
  #number of sets in partition
  r = length(G)  
  
  #matrix of group transitions
  nu = NA * matrix(0,ncol=r,nrow=r)
  
  #calculates the probability from group l -> m
  probOfGroupTransition = function(l,m,G,gamma){
    #stationary distribution
    p0 = stat_distr(gamma)
    
    #probability for G_l
    sumGroup_l = sum(p0[G[[l]]])
    
    erg=0
    for(g in G[[m]]){
      for(h in G[[l]]){
        erg = erg + p0[h]/sumGroup_l * gamma[h,g]  
      } 
    }
    return(erg)
  }
  
  #set starting parameter for nu matrix
  for(i in 1:r){
    for(j in 1:r){
      nu[i,j] = probOfGroupTransition(l=i,m=j,G=G,gamma=gamma)
    }
  }
  
  return(nu)
  
}
