nuP2Gamma <-
function(nuPList,G){
  
  nu = nuPList$nu
  pList = nuPList$pList
  m=length(unlist(pList))
  
  getGroupOfIndex = function(i,G){
    r=length(G)
    for(l in 1:r){
      if(any(G[[l]]==i)) return(l)  
    }
  }
  
  getPositionInGroup = function(i,G){  
    group = getGroupOfIndex(i,G)
    return(which(G[[group]]==i))  
  }
  
  
  #set gamma matrix back 
  gamma = NA * matrix(0,ncol=m,nrow=m)
  
  for(i in 1:m){
    for(j in 1:m){
      gamma[i,j] = nu[getGroupOfIndex(i,G),getGroupOfIndex(j,G)] * pList[[getGroupOfIndex(j,G)]][getPositionInGroup(j,G)]  
    }
  }
  
  return(gamma)
  
}
