#definiere Klasse HMM
setClass("hmmClass",representation = representation(transitionMatrix="matrix",
                                                    stateParameters = "list",
                                                    probList = "list",
                                                    internVariables = "list"))
#definiere Klasse normal und MvNormal HMM
setClass("hmmClassNormal",contains="hmmClass",representation = representation(distribution="character"))
setClass("hmmClassMvNormal",contains="hmmClass",representation = representation(distribution="character"))


#define show for normal HMM
setMethod("show",signature(object="hmmClassNormal"),
          function(object){
            r = object@internVariables$r
            
            cat("\n normal HMM:\n")
            cat("------------\n\n")
            
            cat("transition probability matrix:\n")
            tpmCat = format(round(object@transitionMatrix,4),nsmall=4,digits=2,scientific=FALSE)
            for(i in 1:r) cat("\t",tpmCat[i,],"\n")
            cat("\n")
            
            params = round(rbind(object@stateParameters$mu,object@stateParameters$sigma),4)
            paramsCat = format(params,nsmall=2,digits=1,scientific=FALSE)
            
            cat("mixture proportions: \n")
            for(i in 1:r) 
              cat("\t","state ",i,":", format(round(object@probList[[i]],4),nsmall=4,digits=2),"\n")
            cat("\n")
            
            cat("means: \n")
            cat("\t", paramsCat[1,],"\n\n")
            
            cat("standard deviations: \n")
            cat("\t", paramsCat[2,],"\n \n")
            
          }          
)

#define show for normal HMM
setMethod("show",signature(object="hmmClassMvNormal"),
          function(object){
            r = object@internVariables$r
            m = object@internVariables$m
            k = object@internVariables$k
            
            cat("\n multivariate - normal HMM:\n")
            cat(" --------------------------\n\n")
            
            cat("transition probability matrix:\n")
            tpmCat = format(round(object@transitionMatrix,4),nsmall=4,digits=2,scientific=FALSE)
            for(i in 1:r) cat("\t",tpmCat[i,],"\n")
            cat("\n")
            
            cat("mixture proportions: \n")
            for(i in 1:r) 
              cat("\t","state ",i,":", format(round(object@probList[[i]],4),nsmall=4,digits=2),"\n")
            cat("\n")
            
            cat("means: \n")
            formatedMu = format(round(object@stateParameters$mu,4),nsmall=2,digits=1)
            for(i in 1:m)
              cat("\t", formatedMu[i,],"\n")
            cat("\n")
            
            cat("standard deviations: \n")
            formatedSigma = format(round(object@stateParameters$sigma,4),nsmall=2,digits=1)
            for(i in 1:m){
              cat("\t")
              for(j in 1:k){
                if(j<k)
                  cat(formatedSigma[i,,j],"\t|\t")
                else
                  cat(formatedSigma[i,,j])              }
              cat("\n")
            }
            cat("\n")          
          }          
)

