setHMM <-
function(transitionMatrix,mu,sigma,probList = as.list(rep(x=1,times=dim(transitionMatrix)[1]))){
  
  if(dim(transitionMatrix)[1] != length(probList))
    return("Dimension of transitionMatrix and probList does not match!")
  
  #set distribution
  if(class(mu)=="numeric"||class(mu)=="integer")
    {distribution="normal"; m=1}
  if(class(mu)=="matrix")
    {distribution="mv_normal";m = dim(mu)[1]}
  
  r = dim(transitionMatrix)[1]
  k = length(unlist(probList))
  
  G = list()
  j=1
  for(i in 1:r){
    G[[i]] = j:(j+length(probList[[i]])-1)
    j = j+length(probList[[i]])
  }

  internVariables = list(r=r,k=k,G=G,m=m,distribution=distribution)

  if(distribution=="normal")
    outputClass =   return(new("hmmClassNormal",transitionMatrix=transitionMatrix,stateParameters=list(mu=mu, sigma=sigma),
                               probList=probList,internVariables=internVariables,distribution="normal"))
  if(distribution=="mv_normal")
    outputClass =   return(new("hmmClassMvNormal",transitionMatrix=transitionMatrix,stateParameters=list(mu=mu, sigma=sigma),
                               probList=probList,internVariables=internVariables,distribution="mv_normal"))  
  
}
