\name{findIndependencePartition}
\alias{findIndependencePartition}
\title{
Find independence partition.
}
\description{
This function finds via backward selection the independence partition of the HMM given a dataset, see Holzmann and Schwaiger (2013).
}
\usage{
findIndependencePartition(m, x, alpha = 0.05, estimateIn, details = FALSE, hmm = NULL, ...)
}
\arguments{
  \item{m}{
the number of states of the initial HMM
}
  \item{x}{
the dataset
}
  \item{alpha}{
the level for iterative testing, we recommend 0.01
}
  \item{estimateIn}{
if the initial model is already estimated (which can be time consuming) it can be supplied to the algorithm here
}
  \item{details}{
TRUE/FALSE: controls the output object (how many details)
}
  \item{hmm}{
if estimateIn is not supplied: optionally an object of type \code{\link[mergeHMM]{hmmClass-class}} can be supplied as staring point for iterative optimization of the initial model, otherwise a (unrestricted) starting HMM is calculated using the package RHmm
}
  \item{\dots}{
additional optional parameters passed to \code{\link[mergeHMM]{mleHMM}}
}
}

\value{
a list
\item{pValuePath}{the p-values}
\item{finalModel}{the final model}
\item{finalG}{the according final partition -> the found independence partition}
only if details=TRUE:
\item{modelPath}{a list containing the p-value optimal model in each step of the iterative algorithm}
\item{GPath}{a list containing the partitions according to the models in the list modelPath}
\item{loglikePath}{the values of the log-likelihoods}
\item{likelihoodRatioPath}{the values of the likelihood ratios}
}
\references{
Holzmann, H. and Schwaiger, F. (2013). Hidden Markov models with state-dependent mixtures: Minimal representation, model testing and applications to clustering.
}

\seealso{
\code{\link[mergeHMM]{investigateMergedHMMs}}
}
\examples{
#setting an HMM which has independence partition {{1,2,3},{4}}
r1 = c(0.8 * c(1/3,1/3,1/3), 0.2)
r4 = c(0.1 * c(1/3,1/3,1/3), 0.9)
tpm0 = rbind(r1,r1,r1,r4)
mu0 = c(1,4,9,15)
sigma0 = rep(0.8,4)
hmm0= setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0)

#simulating a dataset
set.seed(1)
x = simulateHMM(n=500, hmm=hmm0)$data
plot(density(x))
rug(x)

#find at first independence partition and save it
indepObj= findIndependencePartition(m=4,x=x,alpha=0.01)

estHmm = indepObj$finalModel
estPartition = indepObj$finalG

#find density based cluster using LDE and dependence structure restriction
obj0  = investigateMergedHMMs(x=x,hmm=estHmm,independenceClusters=estPartition)

#seek for an elbow -> second model
plot(obj0$localDecodingEntropies,type="b",pch=19)

finalHmm = obj0$modelPath[[2]] ; finalHmm
#third state could be included (w.r.t. dependence structure), 
#is not since it would not produce a density based cluster,
#LDE finds here the right model...
}
\keyword{ hmm }
\keyword{ independence }
\keyword{ partition }
\keyword{ cluster }

