\name{hmmClass-class}
\docType{class}
\alias{hmmClass-class}
\alias{hmmClassNormal-class}
\alias{hmmClassMvNormal-class}
\title{Class for hiddenMarkovModels.}
\description{Hidden Markov model class.}
\section{Objects from the Class}{
Objects should be set with the function \code{\link[mergeHMM]{setHMM}}.
}
\section{Slots}{
Each model has the following five slots. 
\describe{
  \item{\code{distribution}:}{a character, specifies the state-dependent distribution.}  
  \item{\code{transitionMatrix}:}{a square matrix, represents the transition probability matrix}
   \item{\code{stateParameters}:}{a list, specifies the state-dependent parameters of the HMM}   
   \item{\code{probList}:}{a list, specifies the weights of the state-dependent finite mixtures.}  
\item{\code{internVariables}:}{a list, contains several intern variables.}  
}
}
\section{Methods}{
For each model the following generic functions are provided: 
\describe{
     \item{investigateMergedHMMs:}{ find density based cluster }    
     \item{mergeHMM:}{ merge states of the HMM }
     \item{reduceHMM:}{ reduce dependence information of the HMM }
     \item{simulateHMM:}{ simulate a dataset }
     \item{viterbiHMM:}{ apply Viterbi algorithm for maximum a-posteriori estimation }
  }
}
\section{Extends}{
  The classes
  \describe{
    \item{\code{hmmClassNormal}}{}
    \item{\code{hmmClassMvNormal}}{}
  }
  extend the class \code{hmmClass}.
}

\seealso{
\code{\link[mergeHMM]{setHMM}}
}

\keyword{hidden}
\keyword{Markov}
\keyword{model}
