\name{investigateMergedHMMs}
\alias{investigateMergedHMMs}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Find density based clusters
}
\description{
This function implements the clustering algorithm using the local decoding entropy (LDE) as proposed in Holzmann and Schwaiger (2013). The HMM and its independence clusters have to be estimated before. To find the independence partition and estimate the model use the function \code{\link[mergeHMM]{findIndependencePartition}}. In order to find the final model plot the values of the LDE, see the example below.
}
\usage{
investigateMergedHMMs(x, hmm, independenceClusters)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
dataset
}
  \item{hmm}{
an object of type \code{\link[mergeHMM]{hmmClass-class}}, no state-dependent mixtures, since it is the initial model. Typically estimated using the function \code{\link[mergeHMM]{findIndependencePartition}}.
}
  \item{independenceClusters}{
a list, which is a partition of the state space 1,...,k (each list entry is thus a vector), this partition defines the flexibility for merging. Also obtained from \code{\link[mergeHMM]{findIndependencePartition}}, see the example below.
}
}
\value{
a list
\item{modelPath}{a list containing the local decoding optimal model in each step of the iterative algorithm}
\item{GPath}{a list containing the partitions according to the models in the list modelPath}
\item{localDecodingEntropies}{the values of the local decoding entropies}
}
\references{
Holzmann, H. and Schwaiger, F. (2013). Hidden Markov models with state-dependent mixtures: Minimal representation, model testing and applications to clustering.
}

\seealso{
\code{\link[mergeHMM]{findIndependencePartition}}
}
\examples{
#setting an HMM which has independence partition {{1,2,3},{4}}
r1 = c(0.8 * c(1/3,1/3,1/3), 0.2)
r4 = c(0.1 * c(1/3,1/3,1/3), 0.9)
tpm0 = rbind(r1,r1,r1,r4)
mu0 = c(1,4,9,15)
sigma0 = rep(0.8,4)
hmm0= setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0)

#simulating a dataset
set.seed(1)
x = simulateHMM(n=500, hmm=hmm0)$data
plot(density(x))
rug(x)

#find at first independence partition and save it
indepObj= findIndependencePartition(m=4,x=x,alpha=0.01)

estHmm = indepObj$finalModel
estPartition = indepObj$finalG

#find density based cluster using LDE and dependence structure restriction
obj0  = investigateMergedHMMs(x=x,hmm=estHmm,independenceClusters=estPartition)

#seek for an elbow -> second model
plot(obj0$localDecodingEntropies,type="b",pch=19)

finalHmm = obj0$modelPath[[2]] ; finalHmm
#third state could be included (w.r.t. dependence structure), 
#is not since it would not produce a density based cluster,
#LDE finds here the right model...
}
\keyword{ LDE }
\keyword{ local   }
\keyword{ decoding  }
\keyword{ entropy }
\keyword{ cluster }

