\name{localDecodingEntopie}
\alias{localDecodingEntopie}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Calculate Local decoding entropies.
}
\description{
The local decoding entropy (LDE) is the sum of the entropies of the a-posteriori probabilities for the hidden Markov chain to attain at time t state j (j=1,..,k) given the whole observable process, see Holzmann an Schwaiger (2013). This function calculates the LDE of an HMM when merging the states w.r.t. partition G. The input has to be an usual HMM (non-mixture state-dependent distributions) and the partition G which gives the states to be merged. The reason for this parametrization is, that so we can easily compare LDE-values when merging w.r.t. different partitions. We adapted the functions of Zucchini (2009) for calculating local decoding probabilities to the setting with potentially mixtures as state dependent distributions.
}
\usage{
localDecodingEntopie(x, hmm, G, details = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
dataset
}
  \item{hmm}{
an object of type \code{\link[mergeHMM]{hmmClass-class}}, no state-dependent mixtures, use G for that.
}
  \item{G}{
a list, which is a partition of the state space 1,...,k (each list entry is thus a vector), see the example below.
}
  \item{details}{
if TRUE, also the a-posteriori probabilities are returned
}
}
\value{
a list with entries depending on variable details

\item{entropy}{the local decoding entropy}
\item{probs}{the local decoding a-posteriori probabilities}

}
\references{
Holzmann, H. and Schwaiger, F. (2013). Hidden Markov models with state-dependent mixtures: Minimal representation, model testing and applications to clustering.

Zucchini and MacDonald (2009). Hidden Markov Models for Time Series: An Introduction Using R.
}


\examples{

#setting an HMM which has independence partition {{1,2},{3}}
r1 = c(0.8 * c(0.5,0.5), 0.2)
r3 = c(0.1 * c(0.5,0.5), 0.9)
tpm0 = rbind(r1,r1,r3)
mu0 = c(1,3,7)
sigma0 = rep(0.8,3)
hmm0= setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0)

set.seed(1)
x = simulateHMM(n=500, hmm=hmm0)$data

#LDE of HMM under under different restrictions
localDecodingEntopie(x=x,hmm=hmm0,G=as.list(1:3))
localDecodingEntopie(x=x,hmm=hmm0,G=list(1:2,3))
localDecodingEntopie(x=x,hmm=hmm0,G=list(1:3))
}
\keyword{ LDE }
\keyword{ local   }
\keyword{ decoding  }
\keyword{ entropy }
\keyword{ cluster }

