\name{mergeHMM-package}
\alias{mergeHMM-package}
%\alias{mergeHMM}
\docType{package}
\title{
Investigate the dependence structure of an hidden Markov model
}
\description{
In Holzmann and Schwaiger (2013) we consider hidden Markov models with state-dependent finite mixtures, here implemented for the univariate and multivariate normal distribution. 

This packages provides functions to find an appropriate model by backward selection based on the proposed test (see \code{\link[mergeHMM]{findIndependencePartition}}). A function to calculate local decoding entropies iteratively, as defined in the paper, is also included (see \code{\link[mergeHMM]{investigateMergedHMMs}}). This function can be used to find state-dependent distributions which form a density based cluster. Further, functions to simulate datasets, to estimate models via MLE under dependence-structure restrictions or to perform a maximum-a-posteriori analysis with the Viterbi algorithm are included. Finally, to merge states of a given (estimated) HMM we provide the function \code{\link[mergeHMM]{mergeHMM}}, whereas further explanations of the here considered model class are given in the help file of \code{\link[mergeHMM]{mergeHMM}}.
}
\details{
\tabular{ll}{
Package: \tab mergeHMM\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2013-05-06\cr
License: \tab GPL-2\cr
}

}
\author{
Florian Schwaiger <schwaige@mathematik.uni-marburg.de>
}
\references{
Holzmann, H. and Schwaiger, F. (2013). Hidden Markov models with state-dependent mixtures: Minimal representation, model testing and applications to clustering.

Zucchini and MacDonald (2009). Hidden Markov Models for Time Series: An Introduction Using R.
}

\keyword{ merging }
\keyword{ hidden Markov model }
\keyword{ hmm }
\seealso{
\code{\link[mergeHMM]{findIndependencePartition}}, \code{\link[mergeHMM]{investigateMergedHMMs}}, \code{\link[mergeHMM]{simulateHMM}}, \code{\link[mergeHMM]{mleHMM}}, \code{\link[mergeHMM]{viterbiHMM}} and \code{\link[mergeHMM]{mergeHMM}}
}
\examples{
#setting an HMM which has independence partition {{1,2},{3}}
r1 = c(0.8 * c(0.5,0.5), 0.2)
r3 = c(0.1 * c(0.5,0.5), 0.9)
tpm0 = rbind(r1,r1,r3)
mu0 = c(1,3,7)
sigma0 = rep(0.8,3)
hmm0= setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0)

#simulating a dataset
set.seed(1)
x = simulateHMM(n=500, hmm=hmm0)$data

#estimate unrestricted HMM
mle0 = mleHMM(x=x,m=3); mle0
#applying Viterbi algorithm
viterbiHMM(x=x,hmm=mle0$mle)

#merging states 
mergedModel1 = mergeHMM(hmm=hmm0,G=list(1:2,3)); mergedModel1
mergedModel2 = mergeHMM(hmm=mle0$mle,G=list(1:2,3)); mergedModel2

#for examples of the main algorithms see the help files of
#findIndependencePartition and investigateMergedHMMs
}
\keyword{ merge }
\keyword{ hmm   }
\keyword{ hidden  }
\keyword{ markov }
\keyword{ model }