\name{mergeHMM}
\alias{mergeHMM}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Merging a hidden Markov model.
}
\description{
This page documents the function \code{mergeHMM}. For the package overview see \code{\link[mergeHMM]{mergeHMM-package}}.

The function \code{mergeHMM} merges states of an HMM given a partition of the state space 1,...,k of the according hidden Markov chain, i.e. an HMM is mapped onto a new HMM. Note that the given partition should divide the state space into r<k groups. The new HMM has a transition probability matrix with entries being the transition probabilities between the groups of the given partition w.r.t. the input transition probability matrix. The new state dependent distributions are given by mixtures of the input state dependent distributions, whereas the mixture proportions are given by the (stationary) conditional state probabilities within the according group, see the reference and the example below.
}
\usage{
mergeHMM(hmm, G)
}
\arguments{
  \item{hmm}{
an object of type \code{\link[mergeHMM]{hmmClass-class}}. For creating such an object use \code{\link[mergeHMM]{setHMM}} or functions which estimate it, i.e. \code{\link[mergeHMM]{findIndependencePartition}}.
}
  \item{G}{
a list, which is a partition of the state space 1,...,k (each list entry is thus a vector), see the example below.
}
}
\details{
Consider the input HMM to have k states. Than the partition \code{G} has to be a list with r<k entries, whereas each list entry (an integer vector) represents a group of states being a subset of the state space 1,...,k. All list entries have to be disjoint. The output HMM has r states. The transition probability matrix is given by the group transition probabilities induced by the input transition matrix and the groups given by \code{G}. As described above the state-dependent distributions of the merged model are mixtures given by the (stationary) state probabilities within the groups.

The observable process of the resulting HMM has exactly the same distribution as the observable part of a reduced HMM, which can be found using the function \code{\link[mergeHMM]{reduceHMM}}. The difference between both models is only the state interpretation: In the reduced HMM we still deal with k states. In case of merging the latent mixture states are not interpreted as states anymore and the mapping results in an r state HMM. 

Note, that both functions in general change the time-series model. Only iff the transition matrix has a special structure the probabilistic structure of the observable process in both cases is not changed. To check whether a transition matrix possesses has this structure, it simply has to be checked if the matrix does not change when the function \code{\link[mergeHMM]{reduceTpm}} is applied. For more theoretical background see the paper below. 
}
\value{
an object of type \code{\link[mergeHMM]{hmmClass-class}}.
}
\references{
Holzmann, H. and Schwaiger, F. (2013). Hidden Markov models with state-dependent mixtures: Minimal representation, model testing and applications to clustering.
}

\note{
The merged HMM is here NOT estimated in the restricted parameter space. No dataset is needed, it is simply a mapping of the model. For estimating under the restriction that state dependent distributions are mixtures, use the function \code{\link[mergeHMM]{mleHMM}} and see the the examples there.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[mergeHMM]{mergeHMM-package}}, \code{\link[mergeHMM]{mleHMM}}, \code{\link[mergeHMM]{reduceHMM}}, \code{\link[mergeHMM]{reduceTpm}} and \code{\link[mergeHMM]{setHMM}}.
}
\examples{
#first example:
#  setting a five state HMM with strongly persistent structure in the hidden Markov chain
#  the dependence structure will change under merging or reducing

#settinng the input HMM (five states)
tpm1 = matrix(c(0.92,0.02,0.02,0.02,0.02,
                0.02,0.92,0.02,0.02,0.02,
                0.02,0.02,0.92,0.02,0.02,
                0.02,0.02,0.02,0.92,0.02,
                0.02,0.02,0.02,0.02,0.92),ncol=5,nrow=5,byrow=TRUE)
mu0 = c(1,3,6,10,15)
sigma0 = rep(1,5)
hmmIn = setHMM(transitionMatrix=tpm1,mu=mu0,sigma=sigma0)

#setting a partition 
# -> sets states 1 and 2, 3 and 4 and 5 each to one group  
G_in = list(1:2,3:4,5)

mergeHMM(hmm=hmmIn,G=G_in)
reduceHMM(hmm=hmmIn,G=G_in) # tpm does change in comparison to tpm1!

#second example:
#  setting a five state HMM with potential for merging
#  the dependence structure of the model will not change under merging or reducing
r12 = c( 0.7 * c(0.9,0.1), 0.2  * c(0.2,0.8), 0.1  )
r34 = c( 0.1 * c(0.9,0.1), 0.8  * c(0.2,0.8), 0.1  )
r5   = c( 0.1 * c(0.9,0.1), 0.05 * c(0.2,0.8), 0.85  )

tpm2 = rbind(r12,r12,r34,r34,r5)
hmmIn2 = setHMM(transitionMatrix=tpm2,mu=mu0,sigma=sigma0)


mergeHMM(hmm=hmmIn2,G=G_in)
reduceHMM(hmm=hmmIn2,G=G_in) # tpm does NOT change in comparison to tpm2!
}
\keyword{ merging }
\keyword{ reducing }

