\name{mleHMM}
\alias{mleHMM}

\title{
Estimating (restricted) HMMs.
}
\description{
This function estimates the (restricted) MLE given a dataset. If restrictions to the dependence structure should be applied, this can be done via the argument G, see the details section and the examples.
}
\usage{
mleHMM(x, m, G = as.list(1:m), hmm = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
the dataset. If it is a vector the univariate normal distribution is used, if it is a matrix (dimensions row-wise) the multivariate normal distribution is used.
}
  \item{m}{
number of states of the Markov chain
}
  \item{G}{
optionally a list, which is a partition of the state space 1,...,k (each list entry is thus a vector). This implies a restriction on the dependence structure, see below.
}
  \item{hmm}{
optionally an object of type \code{\link[mergeHMM]{hmmClass-class}} can be supplied as staring point for iterative optimization, otherwise a (unrestricted) starting HMM is calculated using the package RHmm
}
  \item{\dots}{
If no starting parameter for optimization is supplied (hmm=NULL), then the starting parameter is calculated by using the function HMMfit of the package RHmm by fitting an unristricted HMM. Thus this argument can be used to pass additional control parameters to the function HMMFit, see the help file for further details on that.

If a starting HMM is supplied, then this argument can be used to pass additional parameter to nlm, which calculates iteratively the restricted MLE, see the help file of nlm for further details.
}
}
\details{
With the argument G restrictions to the transition matrix can be applied. Using G = as.list(1:m) gives an unrestricted usual HMM, using G = list(1:m) gives an i.i.d. model. All cases in between are also possible, see the example below. When using restricted estimation a starting value should be supplied because of possible label switching, e.g. by unrestricted estimation before (see example below). 
}
\value{
A list with entries
\item{mle}{object of type \code{\link[mergeHMM]{hmmClass-class}}}
\item{code}{convergence-flag of nlm}
\item{mllk}{value of optimal minus log-likelihood}
\item{AIC}{AIC}
\item{BIC}{BIC}
}


\seealso{
\code{\link{nlm}} and \code{\link[RHmm]{HMMFit}}
}
\examples{
#setting an HMM which has independence partition {{1,2},{3}}
r1 = c(0.8 * c(0.5,0.5), 0.2)
r3 = c(0.1 * c(0.5,0.5), 0.9)
tpm0 = rbind(r1,r1,r3)
mu0 = c(1,3,7)
sigma0 = rep(0.8,3)
hmm0= setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0)

#simulating a dataset
set.seed(1)
x = simulateHMM(n=500, hmm=hmm0)$data

#estimate unrestricted HMM
mle0 = mleHMM(x=x,m=3); mle0

#estimate with correct restriction
mle1 = mleHMM(x=x,m=3,G=list(1:2,3),hmm=mle0$mle); mle1

#estimate with wrong restriction
mle2 = mleHMM(x=x,m=3,G=list(1,2:3),hmm=mle0$mle); mle2

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
