\name{reduceHMM}
\alias{reduceHMM}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Reducing a hidden Markov model.
}
\description{
The function \code{reduceHMM} reduces the dependence structure of the hidden Markov chain of an HMM given a partition of the state space 1,...,k, i.e. an HMM is mapped onto a new HMM. Note that the given partition should divide the state space into r<k groups. The new transition probability from state i to j results by splitting the original state migration into two steps: It is the product of the probability from switching from the group where i is in to the group where j is in AND the probability for state j given the Markov chain is in the group where j is in. The function is detailedly defined in Holzmann and Schwaiger (2013).

The distribution of the observable part (as hole process) of the reduced HMM is the same as for the merged HMM, see \code{\link[mergeHMM]{mergeHMM}}. In general both models differ from the original one. 
}
\usage{
reduceHMM(hmm, G)
}
\arguments{
  \item{hmm}{
an object of type \code{\link[mergeHMM]{hmmClass-class}}. For creating such an object use \code{\link[mergeHMM]{setHMM}}.
}
  \item{G}{
a list, which is a partition of the state space 1,...,k (each list entry is thus a vector), see the example below.
}
}
\value{
an object of type \code{\link[mergeHMM]{hmmClass-class}}.
}
\references{
Holzmann, H. and Schwaiger, F. (2013). Hidden Markov models with state-dependent mixtures: Minimal representation, model testing and applications to clustering.
}

\seealso{
\code{\link[mergeHMM]{mergeHMM}}
}
\examples{
#first example:
#  setting a five state HMM with strongly persistent structure in the hidden Markov chain
#  the dependence structure will change under merging or reducing

#settinng the input HMM (five states)
tpm1 = matrix(c(0.92,0.02,0.02,0.02,0.02,
                0.02,0.92,0.02,0.02,0.02,
                0.02,0.02,0.92,0.02,0.02,
                0.02,0.02,0.02,0.92,0.02,
                0.02,0.02,0.02,0.02,0.92),ncol=5,nrow=5,byrow=TRUE)
mu0 = c(1,3,6,10,15)
sigma0 = rep(1,5)
hmmIn = setHMM(transitionMatrix=tpm1,mu=mu0,sigma=sigma0)

#setting a partition 
# -> sets states 1 and 2, 3 and 4 and 5 each to one group  
G_in = list(1:2,3:4,5)

mergeHMM(hmm=hmmIn,G=G_in)
reduceHMM(hmm=hmmIn,G=G_in) # tpm does change in comparison to tpm1!

#second example:
#  setting a five state HMM with potential for merging
#  the dependence structure of the model will not change under merging or reducing
r12 = c( 0.7 * c(0.9,0.1), 0.2  * c(0.2,0.8), 0.1  )
r34 = c( 0.1 * c(0.9,0.1), 0.8  * c(0.2,0.8), 0.1  )
r5   = c( 0.1 * c(0.9,0.1), 0.05 * c(0.2,0.8), 0.85  )

tpm2 = rbind(r12,r12,r34,r34,r5)
hmmIn2 = setHMM(transitionMatrix=tpm2,mu=mu0,sigma=sigma0)


mergeHMM(hmm=hmmIn2,G=G_in)
reduceHMM(hmm=hmmIn2,G=G_in) # tpm does NOT change in comparison to tpm2!
}
\keyword{ merging }
\keyword{ reducing }
