\name{reduceTpm}
\alias{reduceTpm}
\title{
Reducing dependence information of a Markov chain.
}
\description{
This is the same transformation as in \code{\link[mergeHMM]{reduceHMM}} for the hidden Markov chain, but here the input/output is only a transition probability matrix. 
}
\usage{
reduceTpm(transitionMatrix, G)
}
\arguments{
  \item{transitionMatrix}{
a transition probability matrix of dimension (k x k).
}
  \item{G}{
a list, which is a partition of the state space 1,...,k (each list entry is thus a vector), see the example below.
}
}
\value{
a transition probability matrix of dimension (k x k).
}
\seealso{
\code{\link[mergeHMM]{reduceHMM}}
}
\examples{
#first example
tpm1 = matrix(c(0.92,0.02,0.02,0.02,0.02,
                0.02,0.92,0.02,0.02,0.02,
                0.02,0.02,0.92,0.02,0.02,
                0.02,0.02,0.02,0.92,0.02,
                0.02,0.02,0.02,0.02,0.92),ncol=5,nrow=5,byrow=TRUE)
G_in = list(1:2,3:4,5)
reduceTpm(transitionMatrix=tpm1,G=G_in)

#second example
r12 = c( 0.7 * c(0.9,0.1), 0.2  * c(0.2,0.8), 0.1  )
r34 = c( 0.1 * c(0.9,0.1), 0.8  * c(0.2,0.8), 0.1  )
r5   = c( 0.1 * c(0.9,0.1), 0.05 * c(0.2,0.8), 0.85  )
tpm2 = rbind(r12,r12,r34,r34,r5)
reduceTpm(transitionMatrix=tpm2,G=G_in)
}
\keyword{ reducing }

