\name{setHMM}
\alias{setHMM}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Setting a hidden Markov model.
}
\description{
This function should be used in order to set an object of type \code{\link[mergeHMM]{hmmClass-class}}. Models with (mixtures of) normal or multivariate normal state-dependent distributions are implemented. For the exact parametrization see the details section.

The functions \code{\link[mergeHMM]{mleHMM}} and \code{\link[mergeHMM]{findIndependencePartition}} estimate HMMs and use the class \code{\link[mergeHMM]{hmmClass-class}} as output.
}
\usage{
setHMM(transitionMatrix, mu, sigma, probList = as.list(rep(x = 1, times = dim(transitionMatrix)[1])))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{transitionMatrix}{
a square matrix, which is a transition matrix
}
  \item{mu}{
the mean parameters, vector or matrix, see details
}
  \item{sigma}{
the scale parameters, vector or array, see details
}
  \item{probList}{
the probabilities of state-dependent finite mixtures, see details
}
}
\details{
The parametrization is as follows: We consider the situation where the number of all mixture states equals k. Thus there are k mean parameters and k variance parameters. In the univariate case we thus have two vectors of dimension k. In the multivariate case (with dimension = d) each mean parameter has d entries, thus we parametrize the hole mean parameter of the HMM by a (d x k) matrix, i.e. the dimensions are row-wise.  For the variance parameter there is for each state one (d x d) matrix, therefore  the variance parameter of the whole model is parametrized by an array of dimension (d x d x k).  

In order to allow for mixtures there is the argument \code{probList}. As default it is a list with k entries where each entry equals one. This parametrizes a common HMM with k states and normal state dependent distributions. 

If e.g. the first state dependent distribution should be a mixture with k1 components then the first list element of \code{probList} has to be a k1-dimensional probability vector (positive and summing up to one). Further the first k1 elements in the mean and variance parameter correspond to this mixture. For the second and further states one proceeds accordingly.

Note, that the number of list entries of \code{probList} (e.g. r) has to be suitable to the given selected transition probability matrix, i.e. the dimension has to be (r x r). In case of some distribution are mixtures and some are just normals all list entries in \code{probList} have to be entered (although some are one). In case of no mixtures r simply equals k. 
}
\value{
an object of type \code{\link[mergeHMM]{hmmClass-class}}.
}

\examples{

#example 1: setting a usual (univariate) normal HMM
tpm1 = matrix(c(0.92,0.02,0.02,0.02,0.02,
                0.02,0.92,0.02,0.02,0.02,
                0.02,0.02,0.92,0.02,0.02,
                0.02,0.02,0.02,0.92,0.02,
                0.02,0.02,0.02,0.02,0.92),ncol=5,nrow=5,byrow=TRUE)
mu1 = c(1,3,6,10,15)
sigma1 = rep(1,5)
hmm1 = setHMM(transitionMatrix=tpm1,mu=mu1,sigma=sigma1); hmm1

#example 2: setting a two state HMM with state-dependent mixtures of (univariate) normals
tpm2 = matrix(c(0.9,0.1,
			   0.1,0.9),ncol=2,nrow=2,byrow=TRUE)
hmm2 = setHMM(transitionMatrix=tpm2,mu=mu1,sigma=sigma1,probList=list(c(1/3,1/3,1/3),c(0.75,0.25))); hmm2

#example3: setting a two state HMM with state-dependent mixtures of (bivariate) normals

sigma0 = array(dim=c(2,2,5))
sigma0[,,1] = matrix(0.3*c(1,0.6,0.6,1),byrow=TRUE,ncol=2)
sigma0[,,2] = matrix(0.3*c(1,-0.6,-0.6,1),byrow=TRUE,ncol=2)
sigma0[,,3] = matrix(1.2*c(0.4,-0.35,-0.35,0.4),byrow=TRUE,ncol=2)
sigma0[,,4] = matrix(0.3*c(4,0.9,0.9,4),byrow=TRUE,ncol=2)
sigma0[,,5] = matrix(0.5*c(1,0.8,0.8,1) ,byrow=TRUE,ncol=2)


mu0 = NA * matrix(0,ncol=5,nrow=2)
mu0[,1] = c(2.5,1.5)
mu0[,2] = c(3.5,2)
mu0[,3] = c(2,7)
mu0[,4] = c(3,0.5)
mu0[,5] = c(2.5,6)

hmm3 = setHMM(transitionMatrix=tpm2,mu=mu0,sigma=sigma0,probList=list(c(0.2,0.5,0.15,0.15),1)); hmm3

}
