\name{simulateHMM}
\alias{simulateHMM}

\title{
Simulate a dataset.
}
\description{
This function simulates a dataset of a given HMM. 
}
\usage{
simulateHMM(n, hmm)
}

\arguments{
  \item{n}{
the sample size
}
  \item{hmm}{
the HMM, i.e. an object of type \code{\link[mergeHMM]{hmmClass-class}}
}
}
\examples{
#setting an HMM which has independence partition {{1,2},{3}}
r1 = c(0.8 * c(0.5,0.5), 0.2)
r3 = c(0.1 * c(0.5,0.5), 0.9)
tpm0 = rbind(r1,r1,r3)
mu0 = c(1,3,7)
sigma0 = rep(0.8,3)
hmm0= setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0)

#simulating a dataset
set.seed(1)
x = simulateHMM(n=500, hmm=hmm0)$data
plot(density(x))
}
\keyword{ simulation }
\keyword{ hidden   }
\keyword{ Markov  }
\keyword{ model }
