\name{viterbiHMM}
\alias{viterbiHMM}
\title{
Viterbi algorithm for normal-mixture HMMs.
}
\description{
Given a dataset and an object of type \code{\link[mergeHMM]{hmmClass-class}} this function calculates the most likely sequence of states. The state dependent distributions can be mixtures of normal or just normal distributions.
}
\usage{
viterbiHMM(x, hmm)
}
\arguments{
  \item{x}{
a dataset. For the univariate case a vector for the multivariate case a matrix, where the dimensions have to be row-wise.
}
  \item{hmm}{
an object of type \code{\link[mergeHMM]{hmmClass-class}}. For creating such an object use \code{\link[mergeHMM]{setHMM}}.
}
}
\details{
The code in Zucchini and MacDonald (2009) was adopted by us to the setting with potentially mixtures as state dependent distributions.
}
\value{
a vector with the most likely sequence of states.
}
\references{
Zucchini and MacDonald (2009). Hidden Markov Models for Time Series: An Introduction Using R.
}
\examples{
#set HMM
tpm0 = matrix(c(0.8,0.2,0.1,0.9),ncol=2,nrow=2,byrow=TRUE)
pList0 = list(c(0.4,0.3,0.3),c(1))
mu0 = c(-4,0,2,10)
sigma0 = c(0.3,0.3,0.3,3)
hmm1 = setHMM(transitionMatrix=tpm0,mu=mu0,sigma=sigma0,probList=pList0)                

#simulate data
dataset = simulateHMM(n=1000,hmm=hmm1)
x = dataset$data
plot(density(x))

#apply viterbi algorithm
viterbiHMM(x=x,hmm=hmm1)

}
\keyword{ viterbi }

