#version 300 es
in vec3 inputPosition;
in vec2 inputTexCoord;
in vec3 inputNormal;

uniform mat4 projection, modelview, normalMat;
uniform int mode;

out vec3 interpolatedNormal; // output normal in camera space
out vec2 interpolatedTexCoord; // output texture coordinate

void main(){
  interpolatedNormal = vec3(normalMat * vec4(inputNormal, 0.0));
  interpolatedTexCoord = inputTexCoord;
  gl_Position = projection * modelview * vec4(inputPosition, 1.0);
}
