#version 300 es
precision highp float;
out vec4 outColor;
in vec3 interpolatedNormal; // interpolated normal in camera space
in vec2 interpolatedTexCoord; // interpolated texture coordinate

#define ANTI_ALIASING
#ifdef ANTI_ALIASING
  float fill(float sdf) {
    return clamp(0.5 - sdf / fwidth(sdf), 0.0, 1.0);
  }
#else
  float fill(float sdf) {
    return step(0.0, -sdf);
  }
#endif

float stroke(float sdf, float strokeWidth) {
  return fill(abs(sdf) - strokeWidth);
}

float circle(vec2 pos, vec2 center, float radius) {
  return length(pos - center) - radius;  
}

void main() {
  vec2 pos = fract(interpolatedTexCoord * 5.0); 
  float circleSDF = circle(pos, vec2(0.5), 0.2);
  float m = fill(circleSDF);
  vec3 backgroundColor = interpolatedNormal;
  vec3 fillColor =  vec3(0.0, 0.0, 0.0);
  outColor.rgb = mix(backgroundColor, fillColor, m);
  outColor.a = 1.0;
}