// -*- c++ -*-

// +--------------------------------------------------------------------+
// | This file is part of MathTL - the Mathematical Template Library    |
// |                                                                    |
// | Copyright (c) 2002-2009                                            |
// | Thorsten Raasch, Manuel Werner                                     |
// +--------------------------------------------------------------------+

#ifndef _MATHTL_H
#define _MATHTL_H

// comprehensive 'lazy' include file

#include <utils/array1d.h>
#include <utils/fixed_array1d.h>
#include <utils/function.h>
#include <utils/function_time.h>
#include <utils/multiindex.h>
#include <utils/plot_tools.h>
#include <utils/random.h>
#include <utils/tiny_tools.h>

#include <algebra/atra.h>
#include <algebra/infinite_vector.h>
#include <algebra/laurent_polynomial.h>
#include <algebra/matrix.h>
#include <algebra/matrix_norms.h>
#include <algebra/multi_laurent_polynomial.h>
#include <algebra/polynomial.h>
#include <algebra/shifted_matrix.h>
#include <algebra/sparse_matrix.h>
#include <algebra/symmetric_matrix.h>
#include <algebra/tensor_base.h>
#include <algebra/tensor.h>
#include <algebra/triangular_matrix.h>
#include <algebra/tridiagonal_matrix.h>
#include <algebra/vector_arithmetics.h>
#include <algebra/vector.h>
#include <algebra/vector_norms.h>

#include <io/matrix_io.h>
#include <io/vector_io.h>

#include <geometry/atlas.h>
#include <geometry/chart.h>
#include <geometry/grid.h>
#include <geometry/point.h>
#include <geometry/sampled_mapping.h>

#include <numerics/bvp.h>
#include <numerics/cardinal_splines.h>
#include <numerics/corner_singularity.h>
#include <numerics/decomposable_matrix.h>
#include <numerics/differences.h>
#include <numerics/eigenvalues.h>
#include <numerics/extrapolation.h>
#include <numerics/gauss_data.h>
#include <numerics/gauss_quadrature.h>
#include <numerics/iteratsolv.h>
#include <numerics/ivp.h>
#include <numerics/matrix_decomp.h>
#include <numerics/multi_differences.h>
#include <numerics/one_step_scheme.h>
#include <numerics/ortho_poly.h>
#include <numerics/preconditioner.h>
#include <numerics/quadrature.h>
#include <numerics/recursion.h>
#include <numerics/rosenbrock.h>
#include <numerics/row_method.h>
#include <numerics/runge_kutta.h>
#include <numerics/schoenberg_splines.h>
#include <numerics/splines.h>
#include <numerics/sturm_bvp.h>
#include <numerics/w_method.h>

#endif
